# Sample Texture 2D Array Node

## Description

Samples a **Texture 2D Array** and returns a **Vector 4** color value for use in the shader. You can override the **UV** coordinates using the **UV** input and define a custom **Sampler State** using the **Sampler** input. Use the **Index** input to specify which index of the array to sample.

NOTE: This [Node](Node.md) can only be used in the **Fragment** shader stage.

## Ports

| Name        | Direction           | Type  | Binding | Description |
|:------------ |:-------------|:-----|:---|:---|
| Texture Array |	Input |	Texture 2D Array  | None | Texture 2D Array to sample |
| Index   | Input |	Vector 1    | None	| Index of array to sample |
| UV      | Input |	Vector 2    | 	UV	| Mesh's normal vector |
| Sampler | Input |	Sampler State | Default sampler state | Sampler for the texture |
| RGBA	| Output	| Vector 4	| None	| Output value as RGBA |
| R	    | Output	| Vector 1	| None	| red (x) component of RGBA output |
| G	    | Output	| Vector 1	| None	| green (y) component of RGBA output |
| B	    | Output	| Vector 1	| None	| blue (z) component of RGBA output |
| A     |	Output	| Vector 1	| None | alpha (w) component of RGBA output |

## Generated Code Example

The following example code represents one possible outcome of this node.

```
float4 _SampleTexture2DArray_RGBA = SAMPLE_TEXTURE2D_ARRAY(Texture, Sampler, UV, Index);
float _SampleTexture2DArray_R = _SampleTexture2DArray_RGBA.r;
float _SampleTexture2DArray_G = _SampleTexture2DArray_RGBA.g;
float _SampleTexture2DArray_B = _SampleTexture2DArray_RGBA.b;
float _SampleTexture2DArray_A = _SampleTexture2DArray_RGBA.a;
```